;; This example shows how to access the firmware from within CP/M+.
;; This example does not work with CP/M2.2
;;
;;---------------------------------------------------------

org &100							;; origin for C/PM .COM programs
nolist
write"test2.com"

.scr_set_mode equ &bc0e
.txt_output equ &bb5a

;;---------------------------------------------------------
;; get address of routine to call to execute
;; a firmware function

ld hl,(&0001)
ld de,&0057
add hl,de
ld (firm_jump+1),hl

;;---------------------------------------------------------
;; change the display mode to mode 1
ld a,1
call firm_jump
defw scr_set_mode

;; display a message on the screen
ld hl,test_message
call display_message

;; quit back to command-line
ret


;;---------------------------------------------------------
;; HL = pointer to null terminated message
.display_message
ld a,(hl)				;; get ASCII character
inc hl					;; increment pointer for next character
or a					;; end of message marker (0)?
ret z					;; quit if end of message marker found.

call display_char		;; send character to console output
jp display_message		;; loop for next char

;;---------------------------------------------------------
.display_char
call firm_jump
defw txt_output			;; firmware function: TXT OUTPUT
ret

;;---------------------------------------------------------
;; execute a firmware function
.firm_jump
jp 0


;;---------------------------------------------------------
.test_message
defb "Hello World!",0

